package com.example.tp5_04;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;

import java.util.ArrayList;


public class CustomAdapter extends BaseAdapter{

    Context context;
    int rowLayout;
    ArrayList<Data> data;

    public CustomAdapter (Context context, int rowLayout, ArrayList<Data> data){
        this.context = context;
        this.rowLayout = rowLayout;
        this.data = data;
    }

    @Override
    public int getCount() {
        return data.size();
    }

    @Override
    public Object getItem(int position) {
        return data.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {


        View rowView;

        LayoutInflater inflater = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        rowView = inflater.inflate(R.layout.list_item, null);

        TextView name   = (TextView) rowView.findViewById(R.id.version_name);
        TextView date   = (TextView) rowView.findViewById(R.id.version_date);
        TextView api    = (TextView) rowView.findViewById(R.id.version_api);
        ImageView icon  = (ImageView) rowView.findViewById(R.id.version_icon);




        Data row = (Data)getItem(position);

        name.setText(row.getName());
        date.setText(row.getDate());
        api.setText("API: "+row.getApi());
        Drawable drawable = ContextCompat.getDrawable(this.context, row.getIcon());
        if(drawable == null) {
            drawable = ContextCompat.getDrawable(this.context, R.drawable.noimage);
        }
        icon.setImageDrawable(drawable);

        return rowView;
    }
}
